# -*- coding: utf-8 -*-
"""
Created on Wed Aug 30 11:19:47 2023

@author: yys
"""

import os
import pandas as pd

# 指定包含CSV文件的文件夹路径
folder_path = "J:\\BJ MWR\\blb\\5T\\"
tt = folder_path.split('\\', 3)[3][:-1]
namelist=folder_path.split('\\', 3)[2]

# tt=folder_path[11:15]
# 获取文件夹内所有CSV文件的文件名
csv_files = [file for file in os.listdir(folder_path) if file.endswith('.csv')]

# 创建一个空的DataFrame来存储合并后的数据
merged_data = pd.DataFrame()

# 循环读取每个CSV文件并将其合并到merged_data中
for csv_file in csv_files:
    file_path = os.path.join(folder_path, csv_file)
    data = pd.read_csv(file_path)
    merged_data = pd.concat([merged_data, data], ignore_index=True)




# 将日期列转换为日期时间类型
merged_data['Timestamp'] = pd.to_datetime(merged_data['Timestamp'])
# 将日期列设置为索引
merged_data = merged_data.set_index('Timestamp')
# data3 = data3.resample('5T').bfill()# 按照5分钟间隔对数据进行重采样，使用向后填充方式填充NaN值
# # 创建参考日期序列
reference_dates = pd.date_range(start=merged_data.index.min(), end=merged_data.index.max(), freq=tt)
# 重新索引为参考日期序列，用NaN填充缺失值
merged_data = merged_data.reindex(reference_dates)

# 重新设置Timestamp列为普通列
merged_data.reset_index(inplace=True)
merged_data.columns.values[0] = 'Timestamp'

# # # 将合并后的数据保存为一个新的CSV文件

combined_data_path = 'J:\\BJ MWR\\'+namelist+'\\'+namelist+'_'+tt+'_all+.csv'
# merged_data.to_csv(combined_data_path, index=False,encoding='utf-8')








